;Potential improvements:
;- if no drive letter given by the user, use the first non-existing drive
;- if no size given by the user, make maximum size ramdisk
;- if more than 1 memory disk loaded, use a single copy of the resident
;  code for all ramdisks
;- there's always another bug, find it!

	page	,132

FDEBUG	equ	0

;------
; XRD.ASM - version 1.0
;
; Date   : 01Oct2000
; Author : Freek Heite
; Email  : fheite@knoware.nl
;
;------
;
; Extended memory RAMDISK for CP/M-86.
;
; Thanks to Tim Olmstedt and John Elliott.
; The test team: Kirk Lawrence and Steve Dubrovich.
;
; In this program, "CP/M-86" is used as a shorthand notation for 
; "CP/M-86 for the IBM PC and IBM PC XT  Version 1.1", which is
; "Copyright (C) 1983, Digital Research".


;============== MASM 5.1 prolog for a .COM file =======================

xrd1	segment para public 'code'
		assume	cs:xrd1
		assume	ds:xrd1
		assume	es:nothing

		org	100h


;============== resident data, placed in non-near FIDD storage ========


RDA00	equ	$

r0000:		jmp	r0100		;jump past resident data & code, to the
					; start of our transient code; only
					; used when running the CMD program

	db	256	dup('s')	;runtime stack for INT E6h handler
xrdstak	equ	$

xmb_ax	dw	?			;base values: the 24 bit address where
xmb_dl	db	?			; the ramdisk starts in extended memory

xk_new	dw	?			;remaining free KB's of extended memory
					; 0...7168 is 0...7 MB

cpmseg	dw	?			;the CP/M-86 code and data segment

e6prev	dw	?,?			;far pointer to previous INT E6 handler

i15prev	dw	?,?			;far pointer to previous INT 15 handler

fidnof	dw	?			;near offset of first FIDD storage byte

xrddrv	db	?			;our drive number (0=A...15=P)

w_verbx	db	0			;0 or 1, meaning no/yes show runtime
					;	 messages

;Below are the parameters for PC-ROM-BIOS INT 15h, function 87h "Move Block".
;This function moves up to 64 KB of data from anywhere to anywhere within the
;first 16 MB of memory within the system - which includes 15 MB of extended
;memory.
;
;When calling this function, ES:SI must hold a far pointer to a GDT with
;6 descriptors, 8 bytes each.
;The descriptors must be 24 bit types (286 model), allowing access to storage
;up to 16 MB (is 2^24 bytes) - even on systems with 386 or higher processors.

xrdgdt	equ	$			;the Global Descriptor Table

desc1:					;dummy descriptor
	db	8 dup(0)

desc2:					;descriptor of this GDT
	db	8 dup(0)

desc3:					;descriptor of source block
d3limit	dw	128			;segment limit = 128 bytes
d3low	dw	?			;low word of 24-bit address
d3high	db	?			;high byte of 24-bit address
d3acces	db	93h			;CPL0, R/W
d3res	dw	0			;reserved

desc4:					;descriptor of destination block
d4limit	dw	128			;segment limit = 128 bytes
d4low	dw	?			;low word of 24-bit address
d4high	db	?			;high byte of 24-bit address
d4acces	db	93h			;CPL0, R/W
d4res	dw	0			;reserved

desc5:					;descriptor for CS
	db	8 dup(0)

desc6:					;descriptor for SS
	db	8 dup(0)

;area to save the registers when our INT E6h handler gets cotrol

s_ax	dw	?
s_bx	dw	?
s_cx	dw	?
s_dx	dw	?
s_si	dw	?
s_di	dw	?
s_bp	dw	?
s_ss	dw	?
s_sp	dw	?

IF FDEBUG

; M301 AX=xxxxh (0=sel 2=rd 4=wr 6=hom) drv#=xxh fiddrv#=xxh wrtyp=xxh ver=xxh
; Parms at DX:BX=xxxx:xxxxh are: trk=xxxxh sec=xxxxh dmaoff=xxxxh dmaseg=xxxxh

m301	db	0dh,0ah
	db	'M301 AX='
m301a	db	'xxxxh (0=sel 2=rd 4=wr 6=hom) drv#='
m301b	db	'xxh fiddrv#='
m301c	db	'xxh wrtyp='
m301d	db	'xxh ver='
m301e	db	'xxh'
	db	0dh,0ah
	db	'Parms at DX:BX='
m301f	db	'xxxx:'
m301g	db	'xxxxh are: trk='
m301h	db	'xxxxh sec='
m301i	db	'xxxxh dmaoff='
m301j	db	'xxxxh dmaseg='
m301k	db	'xxxxh'
	db	0dh,0ah,0dh,0ah,'$'

ENDIF

;M302 AX=xxxxh (0=sel 2=rd 4=wr 6=ho) tr=xxxxh se=xxxxh drv=xxh prm=xxxx:xxxxh

m302	db	0dh,0ah
	db	'M302 AX='
m302a	db	'xxxxh (0=sel 2=rd 4=wr 6=ho) tr='
m302b	db	'xxxxh se='
m302c	db	'xxxxh drv='
m302d	db	'xxh prm='
m302f	db	'xxxx:'
m302g	db	'xxxxh'
	db	0dh,0ah,'$'

;M303 - Ramdisk Int15h I/O-error: AH=xxh (0=OK 1=parity 2=exception 3=A20fail) 

m303	db	0dh,0ah
	db	'M303 - Ramdisk Int15h I/O-error: AH='
m303a	db	'xxh (0=OK 1=parity 2=exception 3=A20fail)'
	db	0dh,0ah,'$'

RDA99	equ	$


;============== resident code, placed in non-near FIDD storage ========

;Placed in non-near FIDD storage at some segment, starting at offset RCA00.
;So at run time, the offsets are the same as at assembly time.

RCA00	equ	$

;-------------- about interrupt E6h -----------------------------------

comment %

The BIOS of CP/M-86 issues an interrupt E6h whenever it receives a
disk-related call from the CP/M-86 BDOS specifying a disk drive that
is not recognized by the BIOS-itself. The default E6h handler in a standard
CP/M-86 system does nothing but return an error code on the SELDSK call.

This INT E6h interface allows developers to add drivers for additional,
non-standard storage devices: the driver program is stored in FIDD storage
and then hooks this interrupt E6h.
Basically, that's what this XRD program is doing.

Registers on entry to an interrupt E6h handler:

AX = CP/M-86 BIOS function: 0=seldsk 2=read 4=write 6=home. Details of
     these functions can be found in the CP/M-86 System Guide.
BX = offset within the CP/M-86 segment of the INT E6h parameter block, plus 1.
CL = deblock flag a.k.a. write type. Described in the CP/M-86 System Guide.
DX = the CP/M-86 code and data segment. 0051h in a standard CP/M-86 system.

The INT E6h parameter block is 12 bytes. Note that DX:BX points to the second
byte of the parameters, not to the first byte.

- byte biosdk_drive = drive number 0=A...15=P
- byte biosdk_fdrive = drive number as in previous byte, minus the number of
                       drives in the system that are directly controlled by
                       the PC ROM BIOS. Not used by this ramdisk program.
- byte data_182 = deblock flag a.k.a. write type. Not used by this 
                  ramdisk program.
- word biosdk_track = track
- word biosdk_sector = sector
- word biosdk_dma_offs = CP/M-86 BIOS DMA offset
- word biosdk_dma_segm = CP/M-86 BIOS DMA segment
- byte biosdk_verify = verify data written 0=no other=yes. Not used by
                       this ramdisk program.

Registers on return:

AX = return codes as defined in the CP/M-86 System Guide for the actual
     BIOS function being performed
others = same as on entry

In all cases, the CP/M-86 BIOS will copy AX to BX immediately after the
interrupt E6h returns.

 %	;end comment

;-------------- handler for INT E6h -----------------------------------

e6hand:

	mov	cs:s_ss,ss		;save old SS
	mov	cs:s_sp,sp		; and SP

	cli
	mov	sp,cs
	mov	ss,sp			;switch to
	mov	sp,offset xrdstak	; local stack
	sti

	push	es
	push	bx

;------ is this interrupt E6h for our drive?

	mov	es,dx
	mov	bl,es:[bx-1]
	cmp	bl,cs:xrddrv		;our drive?

	pop	bx			;restore
	pop	es			; changed registers

	je	e6h02			;yes, it is our drive

	cli
	mov	ss,cs:s_ss		;restore old SS
	mov	sp,cs:s_sp		; and SP
	sti

	jmp	dword ptr cs:e6prev	;go to previous handler for INT E6h

e6h02:
	push	ds
	push	es

	push	cs
	pop	ds

	mov	s_ax,ax
	mov	s_bx,bx
	mov	s_cx,cx
	mov	s_dx,dx
	mov	s_si,si
	mov	s_di,di
	mov	s_bp,bp

;------ display input parameters for this driver

e6h03:
	cmp	w_verbx,0		;verbose?
	jz	e6h05			;no

	call	dspregs			;format the input

IF FDEBUG
	mov	si,offset m301		;long format
ELSE
	mov	si,offset m302		;short format
ENDIF

	call	dspm			;show it
e6h05:

;------ process function code in AX

	mov	ax,s_ax			;function code in AX

	cmp	ax,0			;seldsk?
	jnz	e6h10			;no		
	call	e6seldsk			
	jmp	e6h95
e6h10:
	cmp	ax,2			;read?
	jnz	e6h20			;no
	call	e6read
	jmp	e6h92
e6h20:
	cmp	ax,4			;write?
	jnz	e6h30			;no
	call	e6write
	jmp	e6h92
e6h30:
	cmp	ax,6			;home?
	jnz	e6h40			;no
	call	e6home
	jmp	e6h90
e6h40:
	cmp	ax,'GK'			;ioctl?
	jnz	e6h50			;no
	cmp	bx,'DB'
	jnz	e6h50
	call	e6ctl			;magic words OK, call ioctl routine
	jmp	e6h97
e6h50:
	mov	ax,1			;unknown function
	mov	bx,ax
	stc
	jmp	e6h95
e6h90:
	mov	ax,s_ax
e6h92:
	mov	bx,s_bx
e6h95:
	mov	cx,s_cx
	mov	dx,s_dx
	mov	si,s_si
	mov	di,s_di
	mov	bp,s_bp
e6h97:
	pop	es
	pop	ds

	cli
	mov	ss,cs:s_ss		;restore old SS
	mov	sp,cs:s_sp		; and SP
	sti
e6h99:
	iret

;-------------- seldsk ------------------------------------------------
e6seldsk:

	mov	ax,fidnof
	add	ax,offset dphxrd - offset RDN00

	mov	bx,ax			;AX := BX := near pointer to DPH

	ret

;-------------- read --------------------------------------------------
e6read:
	call	ts24
	mov	d3low,ax
	mov	d3high,dl

	call	dma24
	mov	d4low,ax
	mov	d4high,dl

	mov	cx,64			;number of words to move

	push	cs
	pop	es
	mov	si,offset xrdgdt	;ES:SI -> descriptor table

	mov	ah,87h
	int	15h

	jc	e6r10			;failure on INT 15h?
	xor	ax,ax			;no, RC := 0
	ret

e6r10:
	mov	al,ah			;show return code in AH
	mov	si,offset m303a
	call	b2hex
	mov	si,offset m303		;failure on INT 15h
	call	dspm

	mov	ax,1			;RC := 1
	ret

;-------------- write -------------------------------------------------
e6write:
	call	dma24
	mov	d3low,ax
	mov	d3high,dl

	call	ts24
	mov	d4low,ax
	mov	d4high,dl

	mov	cx,64			;number of words to move

	push	cs
	pop	es
	mov	si,offset xrdgdt	;ES:SI -> descriptor table

	mov	ah,87h
	int	15h

	jc	e6w10			;failure on INT 15h?
	xor	ax,ax			;no, RC := 0
	ret

e6w10:
	mov	si,offset m303a
	call	w2hex
	mov	si,offset m303		;failure on INT 15h
	call	dspm

	mov	ax,1			;RC := 1
	ret

;-------------- home --------------------------------------------------
e6home:
	nop				;no action
	ret

;-------------- ioctl -------------------------------------------------
e6ctl:
					;routine might receive some kind of
					;data in CX, DX, SI, DI and BP

	nop				;no action

					;routine might return some kind of data
					; in AX, BX, CX, DX, SI, DI and BP
	ret

;-------------- transform track + sector to a 24-bit linear address ---

;Put bits 23...16 in DL, and bits 15...0 in AX.

;One track is 256 sectors of 128 bytes each = 32 kilobytes = 32768 bytes.
;One sector is 128 bytes.

ts24:
	mov	es,s_dx			;ES:BX := far pointer to parameters
	mov	bx,s_bx

	mov	ax,es:[bx+2]		;track (zero-based number)
	mov	cx,32*1024		;32 kilobytes per track
	mul	cx			;DX:AX := track * bytes_per_track

	mov	bx,es:[bx+4]		;sector 0...255
	mov	cl,7			;2^7 = 128 bytes per sector
	shl	bx,cl			;BX := sector * bytes_per_sector

	add	ax,bx			;add sector offset to track offset
	adc	dx,0			;propagate carry to DX

	add	ax,[xmb_ax]		;add base values: the address where the
	adc	dl,[xmb_dl]		; ramdisk starts in extended memory

ts2499:
	ret

;-------------- transform DMA address to a 24-bit linear address ------

;Put bits 23...16 in DL, and bits 15...0 in AX.

dma24:
	mov	es,s_dx			;ES:BX := far pointer to parameters
	mov	bx,s_bx

	mov	ax,es:[bx+6]		;CP/M DMA offset
	mov	cl,4			;shift right to remove
	shr	ax,cl			; bits 3...0
	add	ax,es:[bx+8]		;add CP/M DMA segment,
					; bits 19...4 now in AX

	mov	dx,0			;shift DX:AX 
	mov	cx,4			; four bits to the left
dma2410:
	shl	ax,1			;put MSB of AX into carry
	rcl	dx,1			;put carry into LSB of DX
	loop	dma2410
					;bits 19...16 in DL, bits 15...4 in AX

	mov	bx,es:[bx+6]		;CP/M DMA offset
	and	bx,000fh		;isolate bits 3...0
	add	al,bl			;add CP/M DMA offset bits 3...0 to AX

dma2499:
	ret

;-------------- handler for INT 15h -----------------------------------

;When the XRD ramdisk has been set up, some other program might ask for the
;amount of available extended memory in the system. We should adjust the
;answer for the amount of extended memory used by the XRD ramdisk.

i15hand:

	pushf

	cmp	ah,88h			;report amount of extended memory?
	je	i15h10			;yes

	popf
	jmp	dword ptr cs:i15prev	;no, go to original handler for INT 15h

i15h10:
	mov	ax,cs:xk_new		;remaining, available extended memory

	popf
	clc
	iret

;-------------- convert word in AX to hexadecimal string at [SI]

;Contents of AX is NOT preserved!

w2hex:
	push	ax

	mov	al,ah
	call	b2hex			;convert AH

	pop	ax
					;fall through to convert AL

;-------------- convert byte in AL to hexadecimal string at [SI]

b2hex:
	push	ax
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	n2hex		;convert high nibble of AL
	pop	ax
	and	al,0fh
				;fall through to convert low nibble of AL

;-------------- convert lower nibble of AL to hexadecimal string at [SI];
;		before calling n2hex, make sure the high nibble of AL is zero

n2hex:
	add	al,090h
	daa
	adc	al,040h
	daa
	mov	[si],al
	inc	si

	ret

;-------------- display registers at entry to INT E6h handler ---------

dspregs:

IF FDEBUG

;------ m301

	mov	ax,s_ax			;function code
	mov	si,offset m301a
	call	w2hex

	mov	ax,s_dx			;segment for paramaters
	mov	si,offset m301f
	call	w2hex

	mov	ax,s_bx			;offset for parameters
	mov	si,offset m301g
	call	w2hex

	mov	es,s_dx			;set ES:BX to parameters
	mov	bx,s_bx

	mov	al,es:[bx-1]		;drive number
	mov	si,offset m301b
	call	b2hex

	mov	al,es:[bx]		;FIDD drive number
	mov	si,offset m301c
	call	b2hex

	mov	al,es:[bx+1]		;write type
	mov	si,offset m301d
	call	b2hex

	mov	ax,es:[bx+2]		;track
	mov	si,offset m301h
	call	w2hex

	mov	ax,es:[bx+4]		;sector
	mov	si,offset m301i
	call	w2hex

	mov	ax,es:[bx+6]		;DMA offset
	mov	si,offset m301j
	call	w2hex

	mov	ax,es:[bx+8]		;DMA segment
	mov	si,offset m301k
	call	w2hex

	mov	al,es:[bx+9]		;verify flag
	mov	si,offset m301e
	call	b2hex

ELSE

;------ m302

	mov	ax,s_ax			;function code
	mov	si,offset m302a
	call	w2hex

	mov	ax,s_dx			;segment for parameters
	mov	si,offset m302f
	call	w2hex

	mov	ax,s_bx			;offset for parameters
	mov	si,offset m302g
	call	w2hex

	mov	es,s_dx			;set ES:BX to parameters
	mov	bx,s_bx

	mov	al,es:[bx-1]		;drive number
	mov	si,offset m302d
	call	b2hex

	mov	ax,es:[bx+2]		;track
	mov	si,offset m302b
	call	w2hex

	mov	ax,es:[bx+4]		;sector
	mov	si,offset m302c
	call	w2hex
ENDIF
	
dspr99:
	ret

;-------------- display ASCII$ message at DS:SI through INT 10h -------

;Used by the interrupt E6h handler for displaying messages. As the BDOS
;is not reentrant, we cannot use the standard CP/M-86 calls here.

dspm:
dspm10:
	cld
	lodsb

	cmp	al,'$'			;string terminator?
	jz	dspm99			;yes, done

	mov	ah,0eh			;write in TTY mode
	xor	bx,bx			;BH=0=page BL=0=color
	int	10h

	jmp	short dspm10		;next character

;Tell CP/M-86 that the screen cursor position has changed, so that it knows
;where to write its own next output.

dspm99:
	mov	ah,3			;read cursor position and size
	mov	bh,0
	int	10h			;DH := row, DL := column
	cmp	dh,23
	jbe	dspm99a
	mov	dh,23			;don't set cursor to status line 24
dspm99a:
	mov	es,cpmseg		;the CP/M-86 segment
	mov	es:[351fh],dh		;set cursor line

	ret

RCA99	equ	$


;============== resident data, placed in near FIDD storage ============

;Placed in near FIDD storage in the CP/M-segment, at offset [fidnof].
;So at run time, the offsets are not the same as at assembly time:
;e.g. run time offset of DPHXRD := offset DPHXRD - offset RDN00 + [fidnof].

;The contents of DPBPTR and ALVPTR below are incremented with [fidnof] by
;the transient program, before the data is moved into FIDD storage (see below
;at label R10000).

RDN00		equ	$

;-------------- DPH for ramdisk ---------------------------------------

dphxrd:

xltxrd		dw	0		;no sector translation
scratchxrd	dw	0,0,0		;scratch pad for BDOS
dirbuf		dw	?		;128 byte directory buffer for all DPHs

dpbptr		dw	offset dpbxrd - RDN00	;pointer to DPB
csvptr		dw	0			;no CSV: non-removable media
alvptr		dw	offset alvxrd - RDN00	;pointer to allocation vector

		db	0DBh

;-------------- DPB for ramdisk ---------------------------------------

;Fixed values, for all ramdisk capacities:
;
;- block size BLS=8192; there are 64 sectors of 128 bytes in a block
;- block shift BSH is 6, because BLS=8192
;- block mask BLM is 63, because BLS=8192
;- track size is 32 KB, is 4 blocks of 8 KB;
;  there are 256 sectors of 128 bytes on a track, so SPT=256
;- 512 directory entries, so two 8 KB blocks are used for the directory
;  (DRM=511, AL0=0C0h, AL1=0)
;- no checked directory entries, media is not removable, so CKS=0
;- 1 reserved track (OFF=1), meaning 32 KB (is 4 blocks of 8 KB) are unused.
;
;Note that the track size of 32 KB is also hard coded in routine TS24.


;Variable values, depending on the actual ramdisk size 1...8 MB:
;
;size	MB's	1	2	3	4	5	6	7	8
;size	KB's	1024	2048	3072	4096	5120    6144	7168	8192
;
;DSM	blocks	123	251	379	507	635	763	891	1019
;EXM	mask	7	7	3	3	3	3	3	3
;
;tracks		32	64	96	128	160	192	224	256

;STAT DSK: for 1 MB ramdisk:
;
; 7,936: 128 Byte Record Capacity
;   992: Kilobyte Drive  Capacity
;   512: 32 Byte  Directory Entries
;     0: Checked  Directory Entries
; 1,024: 128 Byte Records / Directory Entry
;    64: 128 Byte Records / Block
;   256: 128 Byte Records / Track
;     1: reserved  Tracks

;STAT DSK: for 8 MB ramdisk:
;
;65,280: 128 Byte Record Capacity
; 8,160: Kilobyte Drive  Capacity
;   512: 32 Byte  Directory Entries
;     0: Checked  Directory Entries
;   512: 128 Byte Records / Directory Entry
;    64: 128 Byte Records / Block
;   256: 128 Byte Records / Track
;     1: reserved  Tracks

;blsxrd		equ	8192		;block size is 32 sectors of 128 bytes

dpbxrd:					;DPB control block

sptxrd		dw	256		;number of 128-byte sectors per track
bshxrd		db	6		;block shift count: blsxrd = (2^6) *128
blmxrd		db	63		;block mask
exmxrd		db	?		;extent mask
dsmxrd		dw	?		;number of blocks minus 1
drmxrd		dw	511		;number of directory entries minus 1,
					;512 dir entries of 32 bytes, total is
					;16 KB is 2 blocks of blsxrd bytes
al0xrd		db	0c0h		;2 directory blocks of blsxrd bytes
al1xrd		db	0		; of blsxrd bytes
cksxrd		dw	0		;no CKS, media is not removable
offxrd		dw	1		;1 reserved track. BDOS adds this when
					;calling BIOS routine "settrk".
		db	0DBh
		
;------ ALV areas for 1019 data blocks (i.e. the DSM for an 8 MB ramdisk),
;       size = (DSM/8)+1 bytes, then rounded up to the next integer value = 129
;	There is no need to allocate a smaller ALV if the ramdisk is less than
;	8 MB, as FIDD memory is allocated in multiples of 1 KB and - even with
;	an 8 MB ramdisk - we do not need more than 1 KB for resident, near
;	FIDD data.

alvxrd		db	129 dup (0)

		db	0DBh

RDN99		equ	$


;============== resident code, placed in near FIDD storage ============

;Placed in near FIDD storage in the CP/M-segment immediately following
;the resident near data right above, at offset [fidnof] plus
;the length of the resident near data, i.e. [fidnof] + RDN99 - RDN00.
;So at run time, the offsets are not the same as at assembly time:
;e.g. run time offset of RCN10 := offset RCN10 - offset RDN00 + [fidnof].

RCN00	equ	$

;rcn10:
;	nop

RCN99	equ	$

;============== end of resident data and code =========================

;============== start of transient code ===============================

r0100:
	mov	ax,cs
	mov	es,ax

	cli
	mov	ss,ax			;switch to
	mov	sp,offset mystack	; local stack
	sti

	mov	cl,25			;return current disk
	int	0e0h
	mov	curdsk,al		;save it

	call	qcpu			;get CPU type
	jnc	r0105			;jump if 286 or higher

	mov	dx,offset m004		;need 286 or higher
	jmp	stoprun
r0105:

;-------------- intro -------------------------------------------------

r1000:
	mov	dx,offset m000		;intro
	call	dspmsg

r1099:

;-------------- check drive letter and command line options -----------

r2000:

;------ check drive

	mov	al,ds:05ch		;1=A...16=P

	cmp	al,0			;any drive given in first FCB?
	jnz	r2010

	mov	dx,offset m019
	jmp	stoprun

r2010:
	dec	al			;make drive number 0=A...15=P
	mov	xrddrv,al

	mov	ah,0
	mov	f50cx,ax		;drive number for SELDSK

	mov	cl,50			;direct BIOS call
	mov	dx,offset f50parm
	int	0e0h

	cmp	bx,0			;drive exists?
	jz	r2015			;no, SELDSK returned zero in BX

	mov	al,xrddrv		;yes, SELDSK returned a DPH-address
	add	al,'A'			
	mov	m018a,al

	mov	dx,offset m018
	jmp	stoprun
r2015:

;------ check options

;Valid options:
;E = format whole ramdisk, not just the directory (slow!)
;V = verbose non-FIDD-related messages
;W = verbose FIDD-related messages
;X = run-time messages (not recommended)
;1...8 = requested ramdisk size in MB's (required parameter)

	mov	bx,0			;index into file name in FCB's 1 and 2
r2025:
	mov	al,[bx][05dh]		;get option character from FCB 1
	call	chkopt

	mov	al,[bx][06dh]		;get option character from FCB 2
	call	chkopt

	inc	bx			;prepare for next option character
	cmp	bx,7			;all eight positions 0...7 scanned?
	jle	r2025			;no, not yet

;------ ramdisk size given?

	mov	ax,xk_req
	mov	si,offset m091c
	call	w2dec

	cmp	xk_req,0		;size requested?
	jnz	r2099			;yes

	mov	dx,offset m010		;no, missing parameter
	jmp	stoprun
r2099:

;-------------- check CP/M-86 version ---------------------------------

; CP/M-86 1.x BDOS call 12 returns version 2.2

r3000:
	mov	cl,12			;get version
	int	0e0h

	cmp	bx,22h			;version 2.2?
	je	r3099			;yes, OK

	mov	dx,offset m003		;invalid version
	jmp	stoprun

r3099:

;-------------- check amount of extended memory -----------------------

r0110:
	mov	ah,88h			;get extended memory size into AX
	int	15h
	jnc	r0120			;jump if INT 15h OK

	mov	dx,offset m009		;error on INT 15h
	jmp	stoprun

r0120:
	mov	xk_org,ax		;KB's reported by PC-ROM-BIOS

;Calculate and show KB's below and above 16 MB boundary. Only 386 and higher
;processors can have more than 16 MB memory. The INT 15h PC-ROM-BIOS functions
;cannot handle more than 16 MB, so anything above 16 MB is discarded.

	cmp	ax,1024*15		;more than 15 MB?
	jbe	r0130			;no, all ext. memory is below 16 MB

	sub	ax,1024*15		;yes, subtract 15 MB, giving the 
	mov	xk_a16,ax		; memory not accessible with INT 15h
	mov	ax,1024*15		;15 MB available below 16 MB boundary
r0130:
	mov	xk_b16,ax		;available ext. memory below 16 MB
					; (0...15 MB)

	mov	ax,xk_org		;total extended memory
	mov	si,offset m091a
	call	w2dec

	mov	ax,xk_a16		;extended memory above 16 MB boundary
	mov	si,offset m091b
	call	w2dec

	mov	ax,xk_b16		;extended memory below 16 MB memory
	mov	si,offset m091e
	call	w2dec

;check that the requested amount of KB's is available

	mov	ax,xk_req
	cmp	ax,xk_org		;available?
	jbe	r0140			;yes
	
	mov	si,offset m092a		;no
	call	w2dec

	mov	ax,xk_b16
	mov	si,offset m092b
	call	w2dec

	mov	dx,offset m092		;not enough extended memory available
	jmp	stoprun
r0140:

;calculate and show amount of KB's used and still unused (all below 16 MB)

	mov	ax,xk_b16
	sub	ax,xk_req
	mov	xk_new,ax

	mov	si,offset m091d
	call	w2dec

;calculate start 24-bit address for ramdisk

	mov	ax,xk_new		;address of first byte of ramdisk
	add	ax,1024			;extended memory starts at 1 MB
	mov	dx,0			;shift DX:AX ten bits to the left,
	mov	cx,10			; transforming from KB's to bytes
r0150:
	shl	ax,1			;put MSB of AX into carry
	rcl	dx,1			;put carry into LSB of DX
	loop	r0150

	mov	xmb_dl,dl		;start: 8 high bits 
	mov	xmb_ax,ax		;start: 16 low bits

;calculate end 24-bit address for ramdisk

	mov	ax,xk_new		;address of first byte of ramdisk
	add	ax,1024			;extended memory starts at 1 MB
	add	ax,xk_req		;add size of ramdisk
	mov	dx,0			;shift DX:AX ten bits to the left,
	mov	cx,10			; transforming from KB's to bytes
r0160:
	shl	ax,1			;put MSB of AX into carry
	rcl	dx,1			;put carry into LSB of DX
	loop	r0160

	sub	ax,1			;minus 1
	sbb	dx,0

	push	dx

	mov	si,offset m091i		
	call	w2hex

	pop	ax
	mov	si,offset m091h
	call	b2hex

	mov	ax,xmb_ax
	mov	si,offset m091g
	call	w2hex

	mov	al,xmb_dl
	mov	si,offset m091f
	call	b2hex
	
	cmp	w_verb,0		;verbose?
	jz	r0199			;no

	mov	dx,offset m091
	call	dspmsg

r0199:

;-------------- pause -------------------------------------------------

	cmp	w_verb,0		;verbose?
	jz	r4005			;no
	call	getenter
r4005:

;-------------- get CP/M-86 code and data segment ---------------------

	call	findcpmseg

;-------------- check for valid BIOS jump table at offset 2500h -------

	call	chkjumptab

;-------------- pause -------------------------------------------------

	cmp	w_verbf,0		;verbose?
	jz	r4010			;no
	call	getenter
r4010:

;-------------- locate & show the FIDD storage descriptor -------------

	call	showdesc

;-------------- check total amount of FIDD storage in kilobytes -------

	call	chkfidkb

;-------------- check that the FIDD segment is above the CP/M-86 segment

	call	chkabove

;-------------- check and show near FIDD details ----------------------

	call	shownear

;-------------- check and show "non-near" FIDD details ----------------

	call	showany

;-------------- check for enough "near" FIDD storage ------------------

	call	chknear

;-------------- pause -------------------------------------------------

	cmp	w_verbf,0		;verbose?
	jz	r5005			;no
	call	getenter
r5005:

;-------------- allocate [fidreqn] KB's of "near" FIDD storage --------

	call	allocnear

;-------------- allocate [fidreqa] KB's of "non-near" FIDD storage ----

	call	allocany

;-------------- relocate ----------------------------------------------

r10000:
	push	cs
	pop	ds

	mov	ax,fidnof
	add	dpbptr,ax
	add	alvptr,ax

r10999:

;-------------- get and display INT E6h handler details ---------------

r12000:
	mov	ax,0
	mov	es,ax

	mov	ax,es:0e6h+0e6h+0e6h+0e6h	;offset current E6 handler
	mov	e6prev,ax
	mov	ax,es:0e6h+0e6h+0e6h+0e6h+2	;segment current E6 handler
	mov	e6prev+2,ax

	cmp	w_verbf,0		;verbose?
	jz	r12999			;no

	mov	ax,e6prev
	mov	si,offset m013d		;show offset old INT E6h handler
	call	w2hex

	mov	ax,e6prev+2
	mov	si,offset m013c		;show segment old INT E6h handler
	call	w2hex

	mov	ax,offset e6hand
	mov	si,offset m013b		;show offset new INT E6h handler
	call	w2hex

	mov	ax,w030c
	mov	si,offset m013a		;show segment new INT E6h handler
	call	w2hex

	mov	dx,offset m013
	call	dspmsg
r12999:

;-------------- get and display INT 15h handler details ---------------

r13000:
	mov	ax,0
	mov	es,ax

	mov	ax,es:015h+015h+015h+015h	;offset current 15 handler
	mov	i15prev,ax
	mov	ax,es:015h+015h+015h+015h+2	;segment current 15 handler
	mov	i15prev+2,ax

	cmp	w_verbf,0		;verbose?
	jz	r13999			;no

	mov	ax,i15prev
	mov	si,offset m016d		;show offset old INT 15h handler
	call	w2hex

	mov	ax,i15prev+2
	mov	si,offset m016c		;show segment old INT 15h handler
	call	w2hex

	mov	ax,offset i15hand
	mov	si,offset m016b		;show offset new INT 15h handler
	call	w2hex

	mov	ax,w030c
	mov	si,offset m016a		;show segment new INT 15h handler
	call	w2hex

	mov	dx,offset m016
	call	dspmsg
r13999:

;-------------- build DPB for ramdisk ---------------------------------

r14000:
	mov	ax,xk_req		;1024...8192 KB's
	shr	ax,1			;divide by 8,
	shr	ax,1			; giving theoretical maximum
	shr	ax,1			;  number of 8 KB blocks

	sub	ax,4			;minus 1 reserved track, is 4 blocks
	dec	ax			;DSM is one less than number of blocks

	mov	dsmxrd,ax
	
	mov	exmxrd,7		;EXM is 7 if BLS=8192 and DSM <= 255
	cmp	ax,255			;is DSM <= 255?
	jbe	r14010			;yes
	mov	exmxrd,3		;no, EXM is 3 as BLS=8192 and DSM > 255
r14010:

	cmp	w_verb,0		;verbose
	jz	r14999			;no

	mov	ax,dsmxrd
	mov	si,offset m021a
	call	w2dec

	mov	al,exmxrd
	mov	ah,0
	mov	si,offset m021b
	call	w2dec

	mov	dx,offset m021
	call	dspmsg

r14999:

;-------------- move resident data and code to non-near FIDD memory ---

r21000:
	mov	si,100h

	mov	di,100h
	mov	es,[w036i]

	mov	cx,RCA99 - RDA00
	jcxz	r21999

	cld
	rep	movsb
r21999:

;-------------- move resident data and code to near FIDD memory -------

r22000:
	mov	si,offset RDN00

	mov	di,[fidnof]
	mov	es,[cpmseg]

	mov	cx,RCN99 - RDN00
	jcxz	r22999

	cld
	rep	movsb

r22999:

;-------------- activate new handlers for interrupts E6h and 15h ------

r25000:
	mov	ax,0
	mov	es,ax

	cli
	mov	ax,offset e6hand
	mov	es:0e6h+0e6h+0e6h+0e6h,ax	;offset new handler
	mov	ax,w036i
	mov	es:0e6h+0e6h+0e6h+0e6h+2,ax	;segment new handler
	sti

	nop

	cli
	mov	ax,offset i15hand
	mov	es:015h+015h+015h+015h,ax	;offset new handler
	mov	ax,w036i
	mov	es:015h+015h+015h+015h+2,ax	;segment new handler
	sti

r25999:

;-------------- format the XRD ramdisk ---------------------------------

r26000:

;calculate number of directory sectors for the drive

	mov	ax,drmxrd		;number of 32 byte directory entries
	inc	ax			;plus 1
	shr	ax,1			;transform 
	shr	ax,1			; to 128 byte sectors

	cmp	w_fmt,0			;format only the directory?
	jz	r26010			;yes

;calculate the total number of sectors for the drive

	mov	al,blmxrd		;block mask for the drive
	mov	ah,0
	inc	ax			;number of 128 byte sectors per block

	mov	dx,dsmxrd		;number of blocks minus 1
	inc	dx			;plus 1
	mul	dx			;AX := total number of 128 byte sectors

r26010:
	push	ax			;save

	mov	si,offset m020b		;show number of sectors
	call	w2dec			; to be formatted

					;setup for first sector
	mov	al,xrddrv
	mov	e6p_biosdk_drive,al	;drive number 0=A...15=P

	mov	e6p_biosdk_fdrive,0	;not used by XRD
	mov	e6p_data_182,0		;not used by XRD

	mov	ax,offxrd		;account for
	mov	e6p_biosdk_track,ax	; reserved tracks

	mov	e6p_biosdk_sector,0	;sector
	mov	e6p_biosdk_dma_offs,offset e5buf	;DMA offset
	mov	e6p_biosdk_dma_segm,cs	;DMA segment
	mov	e6p_biosdk_verify,0	;not used by XRD

	pop	cx			;sector counter (n...1)
	mov	w_count,1		;counter for progress indicator (1...n)

r26040:
	push	cx			;save sector counter

	mov	ax,w_count
	inc	w_count
	mov	si,offset m020a
	call	w2dec

	mov	dx,offset m020		;show current sector
	call	dspmsg

	mov	ax,4			;write
	mov	bx,offset e6parms +1	;offset of the E6h parameters
	mov	cx,0			;not used by XRD
	mov	dx,ds			;segment of the E6h parameters

	int	0e6h			;call XRD

	cmp	al,0			;write OK?
	jz	r26050			;yes

	pop	cx			;no, clean up our stack
	mov	si,offset m012a		;show error code
	call	b2hex

	mov	dx,offset m012
	jmp	stoprun

r26050:
					;prepare for next sector
	mov	ax,e6p_biosdk_sector
	inc	ax
	cmp	ax,sptxrd
	jb	r26060
	inc	e6p_biosdk_track
	mov	ax,0
r26060:
	mov	e6p_biosdk_sector,ax

	pop	cx			;more sectors to process?
	loop	r26040			;yes

	mov	dx,offset m0ah		;line feed
	call	dspmsg
	
r26999:

;-------------- bye ---------------------------------------------------

r99000:

	cmp	w_verb,0		;verbose?
	jz	r99010			;no

	call	rptstak			;report stack usage

r99010:
	mov	cl,13			;reset disk system (flush buffers);
	int	0e0h			;used to activate new CSV's and ALV's

	mov	al,xrddrv
	add	al,'A'
	mov	m014a,al

	mov	ax,xk_req
	mov	si,offset m014b
	call	w2dec

	mov	dx,offset m014		;program ended succesfully
	jmp	stoprun

r99999:

;-------------- end this program --------------------------------------

stoprun:

	mov	cl,9
	int	0e0h			;display message at DX

stoprun2:
	mov	cl,14			;select disk
	mov	dl,curdsk
	int	0e0h

	mov	cl,0			;return to CCP
	mov	dl,0			;free our memory
	int	0e0h

;-------------- check total amount of FIDD storage in kilobytes -------

chkfidkb:

;Calculate, how many KB's of near FIDD storage we need.

	mov	ax,RCN99-RDN00		;required near storage in bytes
	mov	bx,ax			; also in BX
	mov	cl,10
	shr	ax,cl			;make it KB's

	test	bx,03ffh		;exact multiple of kilobytes?
	jz	cfk05			;yes
	inc	ax			;no, round up to the next kilobyte
cfk05:
	mov	fidreqn,ax		;save it

;Calculate, how many KB's of non-near FIDD storage we need.

	mov	ax,RCA99-RDA00		;required storage in bytes
	mov	bx,ax			; also in BX
	mov	cl,10
	shr	ax,cl			;make it KB's

	test	bx,03ffh		;exact multiple of kilobytes?
	jz	cfk07			;yes
	inc	ax			;no, round up to the next kilobyte
cfk07:
	mov	fidreqa,ax		;save it

;show what we need

	mov	ax,fidreqn
	add	ax,fidreqa		;show total KB's needed
	mov	si,offset m071a
	call	w2dec

	mov	ax,fidreqn		;show near KB's needed
	mov	si,offset m071b
	call	w2dec

	mov	ax,fidreqa		;show non-near KB's needed
	mov	si,offset m071c
	call	w2dec

	cmp	w_verbf,0		;verbose?
	jz	cfk10			;no

	mov	dx,offset m071		;show our FIDD storage requirements
	call	dspmsg
cfk10:

;is there enough of FIDD storage?

	mov	ax,fidreqn
	add	ax,fidreqa		;required FIDD KBs (near plus non-near)
	cmp	ax,fidsize		;is it enough?
	jbe	cfk99			;yes, continue

	mov	si,offset m008a		;show total required FIDD size in KB
	call	w2dec

	mov	ax,fidsize
	mov	si,offset m008b		;show available FIDD size in KB
	call	w2dec

	mov	dx,offset m008		;not enough FIDD storage
	jmp	stoprun

cfk99:
	ret

;-------------- about FIDDS -------------------------------------------

comment %

The ultimate reference about FIDDS would be the Digital Research
application note "CP/M-86 FIDDS for the IBM PC" but that note seems to
have been lost in the dust of ages. If you come across it, please post it
in the internet news group "comp.os.cpm" on the internet and/or email me a
copy at fheite@knoware.nl.

Based on some disassembly of the BIOS-part of CP/M-86, I think that there 
are two aspects of FIDDs (= Field Installable Device Drivers):

1. FIDD storage, as explained below. This gives a way to store a device
   driver, resident program etc.

2. The FIDD interrupt 0E6h, described far above in this program. This
   provides a mechanism for the communication between the CP/M-86 BIOS and
   a device driver - as far as that driver is for a block storage device such
   as a ramdisk, harddisk or diskette.

What follows, is my personal interpretation of FIDD storage, from a developer's
point of view:

In their version 1.1 of CP/M-86 for the IBM PC and XT, Digital Research
added a way to reserve, at boot time, from 1 to 99 KB of the RAM memory
in the PC for use by so-called "Field Installable Device Drivers" or FIDD
programs. 

The standard CP/M-86-supplied program SETUP.CMD is used to reserve a
certain amount of this FIDD storage and to write that amount - along with
other CP/M-86 configuration data - to track 0, sector 2 of a boot diskette
or to some (yet unknown to me) place on a harddisk CP/M partition.

When CP/M-86 is booted, the configuration data is read from the boot disk,
and the configured amount of FIDD memory is allocated right behind the
memory that the CP/M-86 BIOS needs for its own code and data, its disk
buffers etc.

The FIDD memory is never released or reused by CP/M-86 so it's a rather
safe place to store device drivers, resident programs etc.

Where to find details about the FIDD memory? At offset 2556h within the
BIOS part of CP/M-86, a few bytes after the BIOS jump table at offset 2500h,
is a near (16-bit) pointer to a "FIDD storage descriptor". This descriptor
itself is made up of four fields (the last two of them not directly related
to storage, but what's in a name?).

1. a WORD giving the size of the FIDD storage in KB's, range 0...99
   (although a WORD, SETUP.CMD only allows values in the range 0...99). 

2. a WORD giving the segment address of the first byte of FIDD storage
   (assuming a zero offset).

3. a WORD giving the offset within the CP/M-86 segment of a 128 byte work
   area commonly called DIRBUF, used for directory operations within the
   CP/M BDOS. This area is used for all disk devices in the system - both
   native devices supported by the CP/M-86 BIOS and non-native devices that
   are controlled through a FIDD device driver; the FIDD device driver can use 
   this system-wide DIRBUF so it doesn't need to reserve its own 128 bytes.

4. a Diskette Parameter Table (DPT). A DPT is 11 bytes long, it tells the
   PC-ROM-BIOS diskette routines (interrupt 13h) some low-level technical
   details about how to handle diskette operations (e.g. the number of sectors
   on a track, the number of bytes in a sector, how long to wait for the
   diskette drive motor to reach its working speed, etc.). 

A program can allocate some (or all) of the FIDD storage to safely store
some resident code for e.g. a "device driver" like this ramdisk program, or
a "resident program" like a screen saver. As CP/M-86 does not provide an
interface to mark some part of FIDD storage as "in use", the application
itself is responsible for manipulating the FIDD storage descriptor.

Basically, there are two ways to allocate some FIDD storage:
 
1. use some KB's of FIDD storage at the end of the FIDD storage area, and
   decrement the first word of the FIDD descriptor with the number of KB's
   you want to use.

2. use some KB's of FIDD storage at the beginning of the FIDD storage area,
   decrement the first word of the FIDD descriptor with the number of KB's
   you want to use, and finally increment the second word of the FIDD
   descriptor with the number of paragraphs you want to use (a paragraph
   is 16 bytes, so multiply your amount of KB's with 64, then add that
   value to the second word in the FIDD storage descriptor).

Btw, as a matter of good housekeeping, you should always set the FIDD
segment to zero if you have allocated all available FIDD memory - whether
you use method 1. or method 2.

As said before, there are two ways to allocate some FIDD storage. Which one
to chose? Methode 2. is probably the simplest, as method 1. might involve
more arithmetic in case the FIDD storage is more than 64 KB (and thus
a segment boundary must be crossed).

But there is more to consider. If you are loading a device driver for
some kind of disk device (ramdisk, harddisk, diskette, whatever), you must
make available to CP/M-86 some data structures describing this disk
device: a DPH, a DPD, room for allocation vectors and directory check
vectors. As a CP/M-86 BIOS can only handle "near pointers" i.e. 16-bits offsets
to these structures, these data structures must reside in a part of the
FIDD storage that can be addressed using the segment value that CP/M-86 is
using for its own code, data etc.

So it is necessary that the first KB's of FIDD storage can be addressed
(reached) from the CP/M-86 code and data segment.

 +----------------------------------+
 |0K                             64K|
 |                                  | the CP/M segment
 |                                  |
 +----------------------------------+
                       .            .
                       .            .
                       .            .
                       +----------------------------------+
                       |0K          .                  99K|
                       |   near     .       non-near      | the FIDD segment
                       |            .                     |
                       +----------------------------------+

The part of FIDD memory that can also be adressed with the CP/M segment,
will be called "near" FIDD storage - as it is near the CP/M segment. The
rest of the FIDD storage, up to the maximum value of 99 KB, will be called
"non-near" FIDD storage or "any" FIDD storage.

Basically, "near" FIDD storage is a scarse resource. In a standard CP/M-86
system with only a diskette drive it cannot be more than about 44 KB. If
the system also has a harddisk with a CP/M-partition on it, there is at
most about 40 KB of "near" FIDD storage. If that is not enough for your
application, you are out of luck - you cannot change the amount of "near"
FIDD storage as you cannot influence the amount of memory that is unused
at the end of the CP/M segment.

You could further increase the total amount of FIDD storage, up to 99 KB, but
that only increases the amount of "non-near" FIDD storage. It would make
the FIDD box in the figure above just extend more to the right.

All this means that you should allocate "non-near" FIDD storage whenever
possible, and allocate the "near" FIDD storage only when needed. Consider
that the user might want to load more FIDD programs than just the one you
are developing. If your full-blown screen saver program would allocate all
KB's of "near" storage, the user would not be able to load a ramdisk
device driver afterwards. But the ramdisk program _must_ have some "near"
storage for its DPH, DPB etc., while a screensaver (very probably) can
reside everywhere in memory and would very well function when running from
"non-near" storage.

Below are the routines this ramdisk program uses for calculating, displaying,
and allocating both types of FIDD storage. As said before, the value of
the FIDD segment can easily be located once the value of the CP/M-86
segment is known. However, there is no simple way to find this value of
the CP/M-86 code and data segment. So there are additional routines for
finding and validating the CP/M-segment.

The amount of code might seem overwhelming, but most of it is just for
displaying what we are doing.

 %	;end comment

;-------------- locate & show the FIDD storage descriptor -------------

showdesc:

	mov	ax,cpmseg		;segment of the FIDD storage descriptor
	mov	si,offset m030a		;show it (normally 0051h)
	call	w2hex

	mov	es,cpmseg		;segment of the FIDD storage descriptor
	mov	bx,es:2556h		;pointer to the FIDD storage descriptor

	mov	ax,bx
	mov	si,offset m030b		;show it (normally 3AC0h)
	call	w2hex
	
	mov	ax,es:[bx]		;size of FIDD storage in KB (0...99)
	mov	fidsize,ax

	mov	si,offset m030d		;show it (varying, depends on the value
	call	w2dec			; placed on the boot disk by SETUP.CMD)

	mov	ax,es:[bx+2]		;segment of FIDD storage
	mov	fidseg,ax
	mov	w030c,ax

	mov	si,offset m030c		;show it (varying, depends on the size
	call	w2hex			; and number of disk drives in system)

	mov	ax,cpmseg		;segment of DIRBUF area
	mov	si,offset m030i		;show it (normally 0051h)
	call	w2hex

	mov	ax,es:[bx+4]		;offset of DIRBUF within CP/M segment
	mov	dirbuf,ax

	mov	si,offset m030j
	call	w2hex			;show it (normally 4BE2h)

;show where the FIDD memory is located

	mov	ax,fidseg		;start segment of FIDD storage
					; (offset is zero)
	mov	si,offset m030e		;show it
	call	w2hex

	mov	ax,fidseg
	mov	bx,fidsize
	cmp	bx,64			;more than 64 KB?
	jbe	showd10			;no

	add	ax,1000h		;yes, add 64 KB to end segment value
	sub	bx,64			;subtract 64 KB from size
showd10:

	mov	w030g,ax
	mov	si,offset m030g		;show end segment of FIDD storage
	call	w2hex

	mov	ax,bx
	mov	cl,10			;from KB's
	shl	ax,cl			; to bytes
	dec	ax			;minus 1 byte

	cmp	fidsize,0		;is FIDD size zero?
	jnz	showd20			;no
	mov	ax,0			;yes, show end offset as zero
showd20:

	mov	w030h,ax
	mov	si,offset m030h		;show end offset of FIDD memory
	call	w2hex

	cmp	w_verbf,0		;verbose?
	je	showd99			;no

	mov	dx,offset m030		;display FIDD storage info
	call	dspmsg

showd99:
	ret

;-------------- check that the FIDD segment is above the CP/M-86 segment

;N.B. The FIDD segment is zero when CP/M-86 has no FIDD memory configured.

chkabove:

	mov	ax,fidseg
	cmp	ax,cpmseg		;FIDD segment above CP/M-86 segment?
	ja	cabo99			;yes, OK
					;no, strange....

	mov	si,offset m083a		;show FIDD segment
	call	w2hex

	mov	ax,cpmseg		;show CP/M-86 segment
	mov	si,offset m083b
	call	w2hex

	mov	dx,offset m083		;FIDD segment not above CP/M-86 segment
	jmp	stoprun

cabo99:
	ret

;-------------- check and show near FIDD details ----------------------

;Isn't it amazing how many things you can tell about only two segments
;and a handful of kilobytes?

shownear:

;Fill in some values we already know: CP/M-86 segment and FIDD segment

	mov	ax,fidseg
	mov	si,offset m031b
	call	w2hex

	mov	ax,fidseg
	mov	si,offset m031d
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m031f
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m031h
	call	w2hex

;Calculate the amount of "near" FIDD storage in KB's. The difference between
;the FIDD segment and the CP/M-86 segment is subtracted from 64 KB, giving
;the theoretical maximum for the amount of "near" FIDD storage. If the actual
;amount of FIDD storage is below the theoretical maximum, all available
;FIDD storage qualifies as "near".

	mov	ax,fidseg		;calculate FIDD segment
	sub	ax,cpmseg		; minus the CP/M-86 segment
	mov	bx,ax			;save result in BX

	mov	cl,6			;convert from 16 byte paragraphs
	shr	ax,cl			; to 1024 byte KB's

	test	bx,003fh		;exact multiple of kilobytes?
	jz	shon05			;yes
	inc	ax			;no, round up to the next kilobyte
shon05:

	cmp	ax,64			;is the difference between CP/M-86
	jb	shon08			; segment and FIDD-segment >= 64 KB?

	mov	w031a,0			;yes, so there's no "near" FIDD storage

	cmp	w_verbf,0		;verbose?
	jz	shon99			;no

	mov	dx,offset m032
	call	dspmsg
	jmp	shon99

shon08:
	neg	ax			;calculate 64 KB minus AX, so AX :=
	add	ax,64			; theoretical max. near FIDD storage

	cmp	ax,fidsize		;larger than available FIDD storage?
	jbe	shon10			;no
	mov	ax,fidsize		;yes, reduce to what's actually present
shon10:
	mov	w031a,ax		;available "near" FIDD storage in KB's
	mov	si,offset m031a
	call	w2dec

	mov	ax,w031a		;available "near" FIDD storage in KB's
	mov	cl,10
	shl	ax,cl			;from KBs to bytes
	dec	ax			;minus 1
	mov	w031e,ax
	mov	si,offset m031e
	call	w2hex

;Now calculate the offsets within the CP/M-86 segment of this near FIDD storage

	mov	ax,fidseg
	sub	ax,cpmseg

	mov	cl,4			;from paragraphs
	shl	ax,cl			; to bytes
	mov	bx,ax			;BX = AX = offset of first "near" byte
	mov	fidnof,ax

	mov	si,offset m031g
	call	w2hex

	mov	ax,w031a		;available "near" FIDD storage in KB's
	mov	cl,10			;from KB's
	shl	ax,cl			; to bytes

	add	ax,bx			;AX := offset of last "near" byte
	dec	ax			;minus 1
	mov	si,offset m031i
	call	w2hex

	cmp	w_verbf,0		;verbose?
	jz	shon99			;no

	mov	dx,offset m031		;show "near" FIDD storage details
	call	dspmsg

shon99:
	ret

;-------------- check and show "non-near" FIDD details ----------------

showany:

	mov	ax,fidsize		;total FIDD size in KB
	sub	ax,w031a		; minus near FIDD size in KB
					;  gives non-near FIDD size in KB

	cmp	ax,0			;is it 0 KB?
	jnz	shoa10			;no

	cmp	w_verbf,0		;verbose?
	jz	shoa99			;no

	mov	dx,offset m034		;no "non-near" FIDD storage
	call	dspmsg
	jmp	shoa99

shoa10:
	mov	si,offset m033a		;amount of non-near FIDD storage
	call	w2dec

	mov	ax,fidseg		;start segment of non-near FIDD storage
	mov	si,offset m033b
	call	w2hex

	mov	ax,w031e		;start offset of non-near FIDD storage
	inc	ax			;plus 1

	cmp	w031a,0			;but: w031e is undefined if there is
	jnz	shoa15			; no near storage available.
	mov	ax,0			;  In that case, AX := 0.
shoa15:
	mov	si,offset m033c
	call	w2hex

	mov	ax,w030g		;end segment of FIDD storage
	mov	si,offset m033d
	call	w2hex

	mov	ax,w030h		;end offset of FIDD storage
	mov	si,offset m033e
	call	w2hex

	cmp	w_verbf,0		;verbose?
	jz	shoa99			;no

	mov	dx,offset m033		;show "non-near" FIDD storage details
	call	dspmsg

shoa99:
	ret

;-------------- check for enough "near" FIDD storage ------------------

chknear:

	mov	ax,fidreqn
	cmp	ax,0			;any "near" FIDD storage required?
	jz	chkn99			;no

	cmp	ax,w031a		;is there enough "near" storage?
	jbe	chkn99			;yes

	mov	dx,offset m007
	call	dspmsg
	jmp	stoprun

chkn99:
	ret

;-------------- allocate "near" FIDD storage --------------------------

;This routine assumes that the required amount of storage is indeed available.

allocnear:

	cmp	fidreqn,0		;do we need any "near" storage?
	jnz	alln10			;yes, proceed
	jmp	alln99			;no, done

;Show allocation details

alln10:
	mov	ax,fidreqn
	mov	si,offset m035a
	call	w2dec

	mov	ax,fidseg
	mov	si,offset m035b
	call	w2hex

	mov	ax,fidseg
	mov	si,offset m035d
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m035f
	call	w2hex

	mov	ax,cpmseg
	mov	si,offset m035h
	call	w2hex

	mov	ax,fidreqn		;required "near" FIDD storage
	mov	cl,10			; from KB's
	shl	ax,cl			;  to bytes

	dec	ax			;minus 1
	mov	bx,ax			;save it
	mov	si,offset m035e
	call	w2hex

	mov	ax,fidnof
	mov	si,offset m035g
	call	w2hex

	mov	ax,fidnof
	add	ax,bx			;required storage in bytes, minus 1
	mov	si,offset m035i
	call	w2hex

;Now, calculate and update the FIDD storage descriptor by
;- converting the number of required KB's to paragraphs, then adding that
;  value to the FIDD segment value
;- and subtracting the number of required KB's from the FIDD size.


	mov	ax,fidsize		;old FIDD size in KB
	sub	ax,fidreqn		;subtract what we need in KB
	mov	fidnsize,ax		;new FIDD size in KB

	mov	si,offset m035k		;show it
	call	w2dec

	mov	ax,fidreqn		;required FIDD size in KB
	mov	cl,6			;convert from KB
	shl	ax,cl			; to 16 byte paragraphs
	add	ax,fidseg		;add old FIDD segment
	mov	fidnseg,ax		;new FIDD segment

	cmp	fidnsize,0		;is the new FIDD size zero?
	jnz	alln20			;no
	mov	fidnseg,0		;yes, set new FIDD segment to zero

alln20:
	mov	ax,fidnseg		;new FIDD segment
	mov	si,offset m035j		;show it
	call	w2hex

	cmp	w_verbf,0		;verbose?
	jz	alln90			;no

	mov	dx,offset m035		;show allocation details etc.
	call	dspmsg

alln90:
	call	updfid			;update the FIDD storage descriptor

alln99:
	ret

;-------------- allocate "non-near" FIDD storage ----------------------

;This routine assumes that the required amount of storage is indeed available.

allocany:

	cmp	fidreqa,0		;do we need any "non-near" storage?
	jnz	alla10			;yes, proceed
	jmp	alla99			;no, done

;Show allocation details

alla10:
	mov	ax,fidreqa
	mov	si,offset m036a
	call	w2dec

	mov	bx,fidreqa		;non-near storage we need
	mov	cl,10			; from KB's
	shl	bx,cl			;  to bytes

	mov	ax,w030h		;offset of the very last FIDD byte

	sub	ax,bx			;calculate offset of first byte to
					; be allocated as "offset of very last
					; FIDD byte" minus "the number of
					; bytes we need".

	inc	ax			;plus 1
	mov	w036c,ax
	mov	si,offset m036c
	call	w2hex

	mov	ax,w030g		;segment of the first byte to allocate

	mov	bx,fidsize
	cmp	bx,64			;is FIDD size 64 KB or less?
	jbe	alla20			;yes
	sub	bx,64			;no
	cmp	bx,fidreqa		;requesting more than (size - 64 KB)?
	jae	alla20			;no
	sub	ax,1000h		;yes, adjust segment

alla20:
	mov	w036b,ax
	mov	si,offset m036b
	call	w2hex

	mov	ax,w030g
	mov	si,offset m036d
	call	w2hex

	mov	ax,w030h
	mov	si,offset m036e
	call	w2hex

;Calculate start of area to be allocated, when using an offset of zero.

	mov	ax,w036b		;segment

	mov	bx,w036c		;divide offset by 16 (its rightmost
	mov	cl,4			; digit is a 0 so we won't lose data)
	shr	bx,cl

	add	ax,bx			;add (offset/16) to segment
	push	ax

	mov	si,offset m036f		;actual start segment
	call	w2hex

	pop	ax			;segment

	mov	bx,fidreqa		;KB's we need
	cmp	bx,64			;more than 64 KB?
	jbe	alla40			;no

	add	ax,1000h		;yes, add 64 KB to end segment value
	sub	bx,64			;subtract 64 KB from size
alla40:

	mov	si,offset m036g		;actual end segment
	call	w2hex

	mov	cl,10			;from KB's
	shl	bx,cl			; to bytes
	dec	bx			;minus 1
	mov	ax,bx
	mov	si,offset m036h		;actual end offset
	call	w2hex

;Calculate start of area to be allocated, when using an offset of 100h.

	mov	ax,w036b		;segment

	mov	bx,w036c		;divide offset by 16 (its rightmost
	mov	cl,4			; digit is a 0 so we won't lose data)
	shr	bx,cl

	add	ax,bx			;add (offset/16) to segment
	sub	ax,10h			;subtract 16 paragraphs = 100h bytes
	push	ax

	mov	w036i,ax
	mov	si,offset m036i		;actual start segment
	call	w2hex

	pop	ax			;segment

	mov	bx,fidreqa		;KB's we need
	cmp	bx,64			;more than 64 KB?
	jbe	alla50			;no

	add	ax,1000h		;yes, add 64 KB to end segment value
	sub	bx,64			;subtract 64 KB from size
alla50:

	mov	si,offset m036j		;actual end segment
	call	w2hex

	mov	cl,10			;from KB's
	shl	bx,cl			; to bytes
	dec	bx			;minus 1
	add	bx,100h			;account for the offset of 100h

	mov	ax,bx
	mov	si,offset m036k		;actual end offset
	call	w2hex

;The FIDD storage descriptor is updated by
;- subtracting the number of required KB's from the FIDD size.

	mov	ax,fidseg		;the FIDD segment is not changed, but
	mov	si,offset m036l		; display it anyway.
	call	w2hex

	mov	ax,fidseg		;FIDD segment
	mov	fidnseg,ax		; is not changed

	mov	ax,fidsize		;FIDD size
	sub	ax,fidreqa		;subtract what we need in KB
	mov	fidnsize,ax		;new FIDD size in KB
		
	mov	si,offset m036m		;show it
	call	w2dec

	cmp	w_verbf,0		;verbose?
	jz	alla90			;no

	mov	dx,offset m036		;show allocation details etc.
	call	dspmsg

alla90:
	call	updfid			;update the FIDD storage descriptor

alla99:
	ret

;-------------- update the FIDD storage descriptor --------------------

;New FIDD segment is in <fidnseg>, new FIDD size is in <fidnsize>.

updfid:

	push	es

	mov	es,cpmseg		;the cpm segment
	mov	bx,es:2500h + 56h	;pointer to FIDD storage descriptor

	mov	ax,fidnsize
	mov	fidsize,ax		;update our working storage
	mov	es:[bx],ax		;new FIDD size in KB

	cmp	ax,0			;if the new FIDD size is zero, then
	jnz	updf10			; also set the FIDD segment to zero
	mov	fidnseg,0
updf10:

	mov	ax,fidnseg
	mov	fidseg,ax		;update our working storage
	mov	es:[bx][2],ax		;new FIDD segment

updf99:
	pop	es
	ret

;-------------- display message$ [DX] on the console ------------------

dspmsg:

	push	ds

	push	cs
	pop	ds

	mov	cl,9			;display string
	int	0e0h

	pop	ds

dspmsg99:
	ret

;-------------- hit ENTER to continue or ctrl-C to stop ---------------

getenter:

	push	ds

	push	cs
	pop	ds

	mov	dx,offset m015		;press enter or control-c
	mov	cl,9			;display string
	int	0e0h

getent10:
	mov	dl,0ffh			;console input
	mov	cl,6			;direct console I/O
	int	0e0h

	cmp	al,0dh			;enter?
	je	getent99		;yes, done

	cmp	al,3			;control-c?
	jne	getent10		;no
	jmp	stoprun2		;yes

getent99:
	pop	ds

	ret

;-------------- check command line option character in AL -------------

chkopt:

	cmp	al,' '		;blank?
	je	chkop99		;yes, ignore it, return

	cmp	al,'a'
	jb	chkop10
	cmp	al,'z'
	ja	chkop10
	sub	al,'a'-'A'	;make uppercase

chkop10:
	cmp	al,'V'		;verbose option?
	jne	chkop20		;no
	mov	w_verb,1	;yes
	jmp	chkop99		;return
chkop20:
	cmp	al,'W'		;verbose FIDD messages?
	jne	chkop30		;no
	mov	w_verbf,1	;yes
	jmp	chkop99		;return
chkop30:
	cmp	al,'X'		;run-time messages?
	jnz	chkop40		;no
	mov	w_verbx,1	;yes
	jmp	chkop99		;return
chkop40:
	cmp	al,'E'		;format all of ramdisk?
	jnz	chkop80		;no
	mov	w_fmt,1		;yes
	jmp	chkop99		;return
chkop80:
	cmp	al,'1'		;digit >=1 ?
	jb	chkop90		;no
	cmp	al,'8'		;digit <= 8?
	ja	chkop90		;no

	mov	m014c,al	;put digit into message M014
	mov	m092c,al	;put digit into message M092

	sub	al,'0'		;from '1'...'8' to requested size in MB's

	mov	ah,0
	push	cx
	mov	cl,10		;transform AX from MB's to KB's
	shl	ax,cl
	mov	xk_req,ax
	pop	cx
	jmp	chkop99
chkop90:
	mov	m002a,al	;report an invalid option
	mov	dx,offset m002
	jmp	stoprun

chkop99:
	ret

;-------------- report stack usage --------------------------------

rptstak:
	push	cs
	pop	es			;scan memory at ES:DI

	mov	di,offset endstak

	cld
	mov	ax,'hf'			;scan for word 'fh'
	mov	cx,STAKSIZ		;scan max. STAKSIZ words
	repe	scasw		

	mov	ax,cx			;stack usage in words
	add	ax,cx			;stack usage in bytes	
	mov	si,offset m017a		;print AX in dec
	call	w2dec
	
	mov	cl,9			;print stack usage
	mov	dx,offset m017
	int	0e0h

	ret

;--------- find CP/M-86 code and data segment -------------------------

; In a "standard" CP/M-86 system, the CP/M-86 code and data segment is 
; at 0051h. To be sure, we sample some data in the system.

; The following values are obtained:
;
; cpmseg1 segment for INT E0h from interrupt table
; cpmseg2 segment for INT E6h from interrupt table
; cpmseg3 segment returned by BDOS call 27 get addr(alloc)
; cpmseg4 segment returned by BDOS call 31 get addr(dpb)
; cpmseg5 segment returned by BDOS call 49 get addr(sysvars)
; cpmseg6 segment for INT 00h from interrupt table
; cpmseg7 segment for INT 1Bh from interrupt table
; cpmseg8 segment for INT 1Ch from interrupt table
; cpmseg9 segment for INT 1Eh from interrupt table
;
; If all these values are the same, that value is taken as the CP/M-86 segment.
;
; If not all values are the same:
;
; - if one or more of them are 0051h, the value 0051h is taken as 
;   the CP/M-86 segment;
;
; - if one or more of them are 3051h, the value 3051h is taken as 
;   the CP/M-86 segment (our DOS debugger loads CPM.SYS at segment 3051h);
;
; - otherwise, we quit as we cannot determine the value of the CP/M-86 segment.
;
; Note:
; The CP/M-86 BIOS executes an INT E2h instruction at offset 02F46, but in a
; standard system the handler for this interrupt is 0000:0000. So this CP/M-
; interrupt E2h will not help us with finding the "real" CP/M-86 segment.

findcpmseg:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:0e0h+0e0h+0e0h+0e0h+2
	mov	cpmseg1,ax		;segment for INT E0h

	cmp	w_verbf,0		;verbose?
	je	findc10			;no

	mov	si,offset m051a
	call	w2hex
	mov	dx,offset m051
	call	dspmsg
findc10:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:0e6h+0e6h+0e6h+0e6h+2
	mov	cpmseg2,ax		;segment for INT E6h

	cmp	w_verbf,0		;verbose?
	je	findc30			;no

	mov	si,offset m053a
	call	w2hex
	mov	dx,offset m053
	call	dspmsg
findc30:

	mov	cl,27			;get addr(alloc)
	int	0e0h
	mov	cpmseg3,es		;segment from BDOS 27

	cmp	w_verbf,0		;verbose?
	je	findc40			;no

	mov	ax,es
	mov	si,offset m054a
	call	w2hex
	mov	dx,offset m054
	call	dspmsg
findc40:

	mov	cl,31			;get addr(disk parms)
	int	0e0h
	mov	cpmseg4,es		;segment from BDOS 31

	cmp	w_verbf,0		;verbose?
	je	findc50			;no

	mov	ax,es
	mov	si,offset m055a
	call	w2hex
	mov	dx,offset m055
	call	dspmsg
findc50:

	mov	cl,49			;get addr(system variables)
	int	0e0h
	mov	cpmseg5,es		;segment from BDOS 49

	cmp	w_verbf,0		;verbose?
	je	findc52			;no

	mov	ax,es
	mov	si,offset m056a
	call	w2hex
	mov	dx,offset m056
	call	dspmsg
findc52:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:0+2
	mov	cpmseg6,ax		;segment for INT 00h

	cmp	w_verbf,0		;verbose?
	je	findc53			;no

	mov	si,offset m057a
	call	w2hex
	mov	dx,offset m057
	call	dspmsg
findc53:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:01bh+01bh+01bh+01bh+2
	mov	cpmseg7,ax		;segment for INT 1Bh

	cmp	w_verbf,0		;verbose?
	je	findc54			;no

	mov	si,offset m058a
	call	w2hex
	mov	dx,offset m058
	call	dspmsg
findc54:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:01ch+01ch+01ch+01ch+2
	mov	cpmseg8,ax		;segment for INT 1Ch

	cmp	w_verbf,0		;verbose?
	je	findc55			;no

	mov	si,offset m052a
	call	w2hex
	mov	dx,offset m052
	call	dspmsg
findc55:

	mov	ax,0
	mov	es,ax			;set ES to zero

	mov	ax,es:01eh+01eh+01eh+01eh+2
	mov	cpmseg9,ax		;segment for INT 1Eh

	cmp	w_verbf,0		;verbose?
	je	findc56			;no

	mov	si,offset m05aa
	call	w2hex
	mov	dx,offset m05a
	call	dspmsg
findc56:

;All segment values have been collected. Are they all the same?

	mov	ax,cpmseg1		;get first segment value
	mov	cpmseg,ax		;assume it's correct

	mov	si,offset cpmseg2
	mov	cx,nsegs-1		;compare to the nsegs-1 other values
findc58:
	cmp	ax,[si]			;equal to first value?
	jne	findc60			;no
	add	si,2			;yes
	loop	findc58			;prepare for next value

	jmp	findc90			;all the same value, done

;Is one or more of these segment values equal to 0051h?

findc60:
	mov	cpmseg,51h		;assume 51h, which is correct 
					; in a standard CP/M-86 system
	push	ds
	pop	es
	mov	di,offset cpmseg1

	mov	cx,nsegs		;search all cpmseg values
	mov	ax,0051h

	cld
	repnz	scasw			;search for 0051h at ES:DI
	jz	findc90			;found 0051h, done

;Is one or more of these segment values equal to 3051h?

findc70:
	mov	cpmseg,3051h		;assume 3051h (we use this when
					; debugging CP/M-86 under DOS)
	push	ds
	pop	es
	mov	di,offset cpmseg1

	mov	cx,nsegs		;search all cpmseg values
	mov	ax,3051h

	cld
	repnz	scasw			;search for 3051h at ES:DI
	jz	findc90			;found 3051h, done

;Not all values the same; and we didn't find any 0051h or 3051h

	mov	dx,offset m059		;CP/M-86 segment cannot be determined
	jmp	stoprun

findc90:
	cmp	w_verbf,0		;verbose?
	je	findc99			;no

	mov	ax,cpmseg		;display CP/M-86 segment value
	mov	si,offset m005a
	call	w2hex

	mov	dx,offset m005
	call	dspmsg

findc99:
	ret

;------------------- check for valid BIOS jump table at offset 2500h --

; This check is done to ensure that we've correctly located the CP/M-86
; code and data segment.
; The BIOS jump table has 21 entries. All entries are supposed to be 2-byte
; short jumps plus a NOP, or 3-byte near jumps. 

chkjumptab:

	mov	es,cpmseg
	mov	di,2500h		;offset of BIOS jump table

	mov	cx,21			;check 21 jump table entries
chkj05:
	mov	al,es:[di]
	cmp	al,0e9h			;opcode for short jump?
	je	chkj10			;yes, OK
	cmp	al,0ebh			;opcode for near jump?
	jne	chkj90			;no, error
chkj10:
	add	di,3			;prepare for next jump table entry
	loop	chkj05			
	jmp	chkj95			;OK, done

chkj90:
	mov	ax,cpmseg		;the CPM segment
	mov	si,offset m006a
	call	w2hex

	mov	ax,di			;offset where no jmp opcode was found
	mov	si,offset m006b
	call	w2hex

	mov	dx,offset m006		;invalid BIOS jump table entry
	jmp	stoprun

chkj95:
	cmp	w_verbf,0		;verbose?
	je	chkj99			;no

	mov	ax,cpmseg		;the CPM segment
	mov	si,offset m061a
	call	w2hex

	mov	dx,offset m061		;BIOS jump table OK
	call	dspmsg

chkj99:
	ret

;-------------- convert word in AX to decimal string at [SI] ----------

;The result is left-justified, no leading zeroes. Trailing positions are not
;touched, so beware of digits that are left over from a previous call that
;used the same destination.

;Repeat dividing by 10 and pushing remainder on stack, until quotient is zero.

w2dec:
	push	ax
	push	cx
	push	dx
	call	w2dec10			;this one does the real work
	pop	dx
	pop	cx
	pop	ax

	ret

w2dec10:
	mov	cx,10			;divisor
	mov	dx,0			;high word of dividend

	div	cx			;AX := (DX:AX)/CX; DX := remainder
	cmp	ax,0			;is the quotient/result zero?
	jz	w2dec20			;yes

	push	dx			;put remainder on stack
	call	w2dec10			;recursively divide by 10
	pop	dx			;get remainder from stack

w2dec20:
	add	dl,'0'			;transform remainder to ASCII
	mov	[si],dl			;store ASCII digit
	inc	si

	ret

;-------------- Determine processor type ------------------------------
;
; Which processor? Carry will be set if less than 286
;

;FLAGS bit 15  bit 14  bit 13  bit 12
;
;86  etc. 1       1       1       1     ; bits are always set
;186 etc. 1       1       1       1     ; bits are always set
;286      0      NT=0    IOP     IOP    ; bit 14 cannot be set in real mode
;386      0       NT     IOP     IOP
;486      0       NT     IOP     IOP
;
;ref.: Intel/Microsoft XMS 2.03 source listing for HIMEM.SYS

qcpu:

	pushf			;save flags

	xor	ax,ax
	push	ax
	popf			;move zero to flags

	pushf
	pop	ax		;retrieve flags

	popf			;restore flags

	and	ax,0f000h	;mask the top four bits
	cmp	ax,0f000h	;are the top four bits all set?
	stc
	je	qcpu99		;yes, it's 8086/8088/80186/80188/V30/V20
	clc			;no, 286 or higher
qcpu99:
	retn

;============== end of transient code =================================


;============== start of transient data ===============================

curdsk		db	0	;current drive at program start

w_count		dw	?	;running counter for M020

f50parm		equ	$	;for BDOS function 50 "direct BIOS call"
f50func		db	9	;BIOS function SELDSK
f50cx		dw	?	;drive 0=A...15=P
f50dx		dw	1	;not "first time"

xk_req		dw	0	;requested ramdisk size in KB's

xk_org		dw	0	;original KB's of extended memory
				; 0...65535 is 0...64 MB

xk_a16		dw	0	;original KB's of extended memory
				; above 16 MB is 0...48 MB

xk_b16		dw	0	;original KB's of extended memory
				; below 16 MB is 0...48 MB

w_fmt		db	0	;0 or 1, meaning no/yes format all of
				; the ramdisk, not just the directory

w_verb	db	0		;0 or 1, meaning no/yes verbose output

;------

w_verbf		db	0	;0 or 1, meaning no/yes verbose INT 15h
				;        and FIDD messages

fidreqn		dw	0	;number of near FIDD KB's required by this pgm:
				;some KB's for DPH, DPB etc.
				;Allocate it at the start of FIDD storage.

fidreqa		dw	0	;number of FIDD KB's required by this program,
				;that can reside anywhere in FIDD storage:
				;all code, and most of the working storage.
				;Allocate it at the high end of FIDD storage.

fidseg		dw	0	;segment for FIDD storage
fidsize		dw	0	;size of FIDD storage in KB (1024 bytes)

fidnseg		dw	0	;new segment for FIDD storage
fidnsize	dw	0	;new size of FIDD storage in KB

w030c		dw	?	;the FIDD segment before we changed it
w030g		dw	?	;segment of last byte of total FIDD storage
w030h		dw	?	;offset of last byte of total FIDD storage

w031a		dw	?	;actually available amount of near FIDD storage
w031e		dw	?	;offset of last byte of near FIDD storage

w036b		dw	?	;segment of first byte of non-near FIDD storage
				; that will be allocated (assuming offset 0)
w036c		dw	?	;offset of first byte of non-near FIDD storage
				; that will be allocated
w036i		dw	?	;segment of first byte of non-near FIDD storage
				; that will be allocated (assuming offset 100h)

;------

nsegs		equ	9	;total number of "cpm segments" checked

cpmseg1		dw	0	;segment for INT E0h (BDOS calls)
cpmseg2		dw	0	;segment for INT E6h (FIDD disk interrupt)
cpmseg3		dw	0	;segment from BDOS call 27 get addr(alloc)
cpmseg4		dw	0	;segment from BDOS call 31 get addr(dpb)
cpmseg5		dw	0	;segment from BDOS call 49 get addr(sysvars)
cpmseg6		dw	0	;segment for INT 00h (overflow)
cpmseg7		dw	0	;segment for INT 1Bh (keyboard break)
cpmseg8		dw	0	;segment for INT 1Ch (user timer tick)
cpmseg9		dw	0	;segment for INT 1Eh (diskette parameters)

;------

m0ah	db	0ah,'$'		;line feed

m000	db	0dh,0ah
	db	'XRD  - An eXtended memory RamDisk for "CP/M-86 for the '
	db	'IBM PC and IBM PC XT".' 
	db	0dh,0ah
	db	'       Version 1.0 - 01Oct2000 - by Freek Heite.'
	db	0dh,0ah,'$'

m002	db	'M002 - Sorry, invalid program option '
m002a	db	'X given. Valid options: E V W X.'
	db	0dh,0ah,'$'

m003	db	'M003 - Sorry, invalid CP/M-86 version. '
	db	'This program needs version 1.1.'
	db	0dh,0ah,'$'

;M030 - The FIDD storage descriptor in the CP/M-86 segment is at xxxx:xxxxh,
;       the FIDD segment is xxxxh, available FIDD storage size is nn KB.
;       The FIDD storage area is from xxxx:0000h - xxxx:xxxxh.
;       The DIRBUF workarea in the CP/M-86 segment is at xxxx:xxxxh.

m030	db	'M030 - The FIDD storage descriptor in the CP/M-86 segment '
	db	'is at '
m030a	db	'xxxx:'
m030b	db	'xxxxh;'
	db	0dh,0ah
	db	'       the FIDD segment is '
m030c	db	'xxxxh, available FIDD storage size is '
m030d	db	'?  KB.'
	db	0dh,0ah
	db	'       The FIDD storage area is from '
m030e	db	'xxxx:'
m030f	db	'0000h - '
m030g	db	'xxxx:'
m030h	db	'xxxxh.'
	db	0dh,0ah
	db	'       The DIRBUF workarea in the CP/M-86 segment is at '
m030i	db	'xxxx:'
m030j	db	'xxxxh.'
	db	0dh,0ah,'$'

;M031 - "Near" FIDD storage is nn KB, from xxxx:0000h - xxxx:xxxxh, 
;       which is xxxx:xxxxh - xxxx:xxxxh within the CP/M-86 segment.

m031	db	'M031 - "Near" FIDD storage is '
m031a	db	'?  KB, from '
m031b	db	'xxxx:'
m031c	db	'0000h -'
m031d	db	'xxxx:'
m031e	db	'xxxxh,'
	db	0dh,0ah
	db	'       which is '
m031f	db	'xxxx:'
m031g	db	'xxxxh - '
m031h	db	'xxxx:'
m031i	db	'xxxxh within the CP/M-86 segment.'
	db	0dh,0ah,'$'

;M032 - No "near" FIDD storage available, all FIDD storage is "non-near".

m032	db	'M032 - No "near" FIDD storage available, '
	db	'all FIDD storage is "non-near".'
	db	0dh,0ah,'$'

;M033 - "Non-near" FIDD storage is nn KB, from xxxx:xxxxh - xxxx:xxxxh.

m033	db	'M033 - "Non-near" FIDD storage is '
m033a	db	'?  KB, from '
m033b	db	'xxxx:'
m033c	db	'xxxxh - '
m033d	db	'xxxx:'
m033e	db	'xxxxh.'
	db	0dh,0ah,'$'

;M034 - Non-"near" FIDD storage is 0 KB, all available FIDD storage is "near".

m034	db	'M034 - "Non-near" FIDD storage is 0 KB, all available '
	db	'FIDD storage is "near".'
	db	0dh,0ah,'$'

;M035 - Allocated nn KB of "near" FIDD storage at xxxx:0000h - xxxx:xxxxh,
;       which is xxxx:xxxxh - xxxx:xxxxh within the CP/M-86 segment.
;       New FIDD segment is xxxxh, new available FIDD storage size is nn KB.

m035	db	'M035 - Allocated '
m035a	db	'?  KB of "near" FIDD storage at '
m035b	db	'xxxx:'
m035c	db	'0000h - '
m035d	db	'xxxx:'
m035e	db	'xxxxh,'
	db	0dh,0ah
	db	'       which is '
m035f	db	'xxxx:'
m035g	db	'xxxxh - '
m035h	db	'xxxx:'
m035i	db	'xxxxh within the CP/M-86 segment.'
	db	0dh,0ah
	db	'       New FIDD segment is '
m035j	db	'xxxxh, new available FIDD storage size is '
m035k	db	'?  KB.'
	db	0dh,0ah,'$'

;M036 - Allocated nn KB of "non-near" FIDD storage at xxxx:xxxx - xxxx:xxxxh,
;       which is xxxx:0000h - xxxx:xxxxh when using a zero offset,
;	which is xxxx:0100h - xxxx:xxxxh when using an offset of 100h.
;       New FIDD segment is xxxxh, new available FIDD storage size is nn KB.

m036	db	'M036 - Allocated '
m036a	db	'?  KB of "non-near" FIDD storage at '
m036b	db	'xxxx:'
m036c	db	'xxxx - '
m036d	db	'xxxx:'
m036e	db	'xxxxh,'
	db	0dh,0ah
	db	'       which is '
m036f	db	'xxxx:0000h - '
m036g	db	'xxxx:'
m036h	db	'xxxxh when using a zero offset,'
	db	0dh,0ah
	db	'       which is '
m036i	db	'xxxx:0100h - '
m036j	db	'xxxx:'
m036k	db	'xxxxh when using an offset of 100h.'
	db	0dh,0ah
	db	'       FIDD segment remains '
m036l	db	'xxxxh, new available FIDD storage size is '
m036m	db	'?  KB.'
	db	0dh,0ah,'$'

m004	db	'M004 - Sorry, this program needs a system with a 286 or '
	db	'higher processor.'
	db	0dh,0ah,'$'

m005	db	'M005 - Ergo conclusio: the CP/M-86 code and data '
	db	'is at segment '
m005a	db	'xxxxh.'
	db	0dh,0ah,'$'

m051	db	'M051 - Segment for INT E0h BDOS call handler is '
m051a	db	'xxxxh.'
	db	0dh,0ah,'$'
m052	db	'M052 - Segment for INT 1Ch user timer tick handler is '
m052a	db	'xxxxh.'
	db	0dh,0ah,'$'
m053	db	'M053 - Segment for INT E6h FIDD handler is '
m053a	db	'xxxxh.'
	db	0dh,0ah,'$'
m054	db	'M054 - Segment for ALV of current drive is '
m054a	db	'xxxxh.'
	db	0dh,0ah,'$'
m055	db	'M055 - Segment for DPB of current drive is '
m055a	db	'xxxxh.'
	db	0dh,0ah,'$'
m056	db	'M056 - Segment for CP/M-86 system variables is '
m056a	db	'xxxxh.'
	db	0dh,0ah,'$'
m057	db	'M057 - Segment for INT 00h overflow handler is '
m057a	db	'xxxxh.'
	db	0dh,0ah,'$'
m058	db	'M058 - Segment for INT 1Bh keyboard break handler is '
m058a	db	'xxxxh.'
	db	0dh,0ah,'$'
m05a	db	'M05A - Segment for INT 1Eh diskette parameter table is '
m05aa	db	'xxxxh.'
	db	0dh,0ah,'$'

m059	db	'M059 - Sorry, cannot determine the CP/M-86 code & data '
	db	'segment.'
	db	0dh,0ah,'$'

m006	db	'M006 - Sorry, the BIOS jump table at address'
m006a	db	'xxxx:2500h in the CP/M-86 segment'
	db	0dh,0ah
	db	'       is invalid: there is no short or near jump '
	db	'opcode at offset '
m006b	db	'xxxxh.'
	db	0dh,0ah,'$'

m061	db	'M061 - The BIOS jump table at '
m061a	db	'xxxx:2500h has valid jump instructions.'
	db	0dh,0ah,'$'

m007	db	'M007 - Sorry, not enough "near" FIDD storage available.'
	db	0dh,0ah,'$'

m071	db	'M071 - This program needs a total of '
m071a	db	'?  KB of available FIDD storage:'
	db	0dh,0ah
	db	'       '
m071b	db	'?  KB as "near" storage, and '
m071c	db	'?  KB as "non-near" storage.'
	db	0dh,0ah,'$'

m008	db	'M008 - Sorry, not enough storage reserved for FIDD''s: '
m008a	db	'?  KB is required,'
	db	0dh,0ah
	db	'       but only '
m008b	db	'?  KB is available.'
	db	0dh,0ah,'$'

m083	db	'M083 - Sorry, the FIDD segment is not '
	db	'above the CP/M-86 segment:'
	db	0dh,0ah
	db	'       FIDD segment is '
m083a	db	'xxxxh, CP/M-86 segment is '
m083b	db	'xxxxh.'
	db	0dh,0ah,'$'

m009	db	'M009 - Sorry, INT 15h error getting extended memory size.'
	db	0dh,0ah,'$'

m091	db	'M091 - BIOS interrupt 15H, function 88h reports '
m091a	db	'?     KB of extended memory:'
	db	0dh,0ah
	db	'       - '
m091b	db	'0     KB of which cannot be accessed through BIOS '
	db	'interrupt 15h,'
	db	0dh,0ah
	db	'       - '
m091e	db	'0     KB of which can be used for XRD ramdisks.'
	db	0dh,0ah
	db	'       '
m091c	db	'0     KB will now be used for an XRD ramdisk,'
	db	0dh,0ah
	db	'       '
m091d	db	'0     KB is still available for XRD ramdisks '
	db	'or other programs.'
	db	0dh,0ah
	db	'       The ramdisk will be at 24-bit addresses '
m091f	db	'xx'
m091g	db	'xxxxh - '
m091h	db	'xx'
m091i	db	'xxxxh.'
	db	0dh,0ah,'$'

m092	db	'M092 - Sorry, you have requested an XRD ramdisk of '
m092a	db	'?    KB ('
m092c	db	'x MB),'
	db	0dh,0ah
	db	'       but there is only '
m092b	db	'?    KB of extended memory available.'
	db	0dh,0ah,'$'

m010	db	'M010 - Sorry, missing parameter. Please specify the XRD '
	db	'ramdisk size in'
	db	0dh,0ah
	db	'       megabytes, with a single digit in the range 1...8.'
	db	0dh,0ah,'$'

m011	db	'M011 - Formatting all '
m011a	db	'?     sectors for the XRD ramdisk.'
	db	0dh,0ah,'$'

m012	db	'M012 - Sorry, write error '
m012a	db	'xxh when formatting the XRD ramdisk directory.'
	db	0dh,0ah,'$'

m013	db	'M013 - Handler for interrupt E6h was '
m013c	db	'xxxx:'
m013d	db	'xxxxh, now changed to '
m013a	db	'xxxx:'
m013b	db	'xxxxh.'
	db	0dh,0ah,'$'

m014	db	'M014 - XRD ramdisk created succesfully. Drive is '
m014a	db	'?:, size is '
m014b	db	'?    KB ('
m014c	db	'x MB).$'

m015	db	'M015 - Press ENTER to continue.......................'
	db	'........................'
	db	0dh,0ah,'$'

m016	db	'M016 - Handler for interrupt 15h was '
m016c	db	'xxxx:'
m016d	db	'xxxxh, now changed to '
m016a	db	'xxxx:'
m016b	db	'xxxxh.'
	db	0dh,0ah,'$'

m017	db	'M017 - This program has used '
m017a	db	'?     bytes on the stack.'
	db	0dh,0ah,'$'

m018	db	'M018 - Sorry, drive '
m018a	db	'?: already exists.'
	db	0dh,0ah,'$'

m019	db	'M019 - Sorry, missing parameter. Specify a '
	db	'non-existing drive in the'
	db	0dh,0ah
	db	'       range A: through P:.'
	db	0dh,0ah,'$'

m020	db	'M020 - Now formatting sector '
m020a	db	'?     of '
m020b	db	'?    .'
	db	0dh,'$'

m021	db	'M021 - Calculated DPH fields: DSM is '
m021a	db	'?   , EXM is '
m021b	db	'?.'
	db	0dh,0ah,'$'

e6parms			equ	$	;described earlier in this program
e6p_biosdk_drive	db	?
e6p_biosdk_fdrive	db	?
e6p_data_182		db	?
e6p_biosdk_track	dw	?
e6p_biosdk_sector	dw	?
e6p_biosdk_dma_offs	dw	?
e6p_biosdk_dma_segm	dw	?
e6p_biosdk_verify	db	?

e5buf	db	128 dup(0e5h)		;buffer for formatting ramdisk sectors

STAKSIZ	equ	128			;size of local stack in words
endstak	equ	$
	db	STAKSIZ dup('fh')	;local stack
mystack	equ	$

;============== end of transient data =================================


;============== MASM 5.1 epilog for a .COM file =======================

xrd1		ends
	end	r0000
