Program StarfieldSimulation;
{ 2D Starfield 1.0                      }
{ Written by Hkon Stordahl 09.09.96    }

{$I GFX3X.PAS}
{$I TERMINAL.INC}
{$I CHECK.INC}

Const
  MaxStars  = 200;
  MaxX      = 319;
  MinX      = 0;
  MaxY      = 199;
  MinY      = 0;
  BgCol     = 0;
  VGA       = $A000;

Type
  Star = RECORD
    X, Y: INTEGER;
    Col : BYTE;
  end;

Var
  StarField: ARRAY[1..MaxStars] OF Star;

Procedure Help;

begin
  WriteLn('2D Starfield 1.0');
  WriteLn('Written by Hkon Stordahl 09.09.96');
  WriteLn;
  WriteLn('Syntax: 2DSTAR');
end;

Procedure InitStars;

Var
  I: INTEGER;

begin
  SetPal(BgCol, 0, 0, 0);   { Background Color     }
  SetPal(1, 13, 13, 13);    { Star-type 1 Color    }
  SetPal(2, 33, 33, 33);    { Star-type 2 Color    }
  SetPal(3, 63, 63, 63);    { Star-type 3 Color    }
  FOR I := 1 TO MaxStars DO
  begin
    Starfield[I].X := Random(MaxX - MinX) + MinX;
    Starfield[I].Y := Random(MaxY - MinY) + MinY;
    Starfield[I].Col := Random(3) + 1;
  end;
end;

Procedure DisplayStars(Where: INTEGER);

Var
  I: INTEGER;

begin
  FOR I := 1 TO MaxStars DO
  begin
    IF GetPixel(Starfield[I].X, Starfield[I].Y, Where) IN[1, 2, 3] THEN
    SetPixel(Starfield[I].X, Starfield[I].Y, BgCol, Where);
    Starfield[I].X:=Starfield[I].X+Starfield[I].Col;
    IF Starfield[I].X > MaxX  THEN Starfield[I].X := MinX;
    IF GetPixel(Starfield[I].X, Starfield[I].Y, Where) = BgCol THEN
    SetPixel(Starfield[I].X, Starfield[I].Y, Starfield[I].Col, Where);
  end;
end;

Var
  I       : INTEGER;
  Ch      : CHAR;
  Tmp     : ARRAY[1..6] OF BYTE;
  Pal     : PalType;

begin
  IF ParamCount <> 0 THEN Help
  ELSE
  begin
    statusoff;
    checkvga;
    Randomize;
    FadeDown;
    SetVideoMode($13);
    InitStars;
    SavePalette(Pal);
    WaitRetrace;
    BlackOut;
    Cls(BgCol, VGA);
    DisplayStars(VGA);
    FadeUp(Pal);
    Repeat
      WaitRetrace;
      DisplayStars(VGA);
    Until KeyPressed;
    {Ch:= ReadKey;}
    Pause;
    FadeDown;
    SetVideoMode($03);
    statuson;
    GetPal(7, Tmp[1], Tmp[2], Tmp[3]);
    SetPal(7, 0, 0, 0);
    GOTOXY(1,1);
    WriteLn('2D Starfield 1.0');
    WriteLn('Written by Hkon Stordahl 09.09.96');
    FOR I := 0 TO 63 DO
    begin
      WaitRetrace;
      Delay(60);
      GetPal(7, Tmp[4], Tmp[5], Tmp[6]);
      IF Tmp[4] < Tmp[1] THEN Tmp[4]:=Tmp[4]+1;
      IF Tmp[5] < Tmp[2] THEN Tmp[5]:=Tmp[5]+1;
      IF Tmp[6] < Tmp[3] THEN Tmp[6]:=Tmp[6]+1;
      SetPal(7, Tmp[4], Tmp[5], Tmp[6]);
    end;
  end;
end.